\version "2.18.0"
\language "deutsch"

\paper {
  %system-system-spacing = #'((basic-distance . 23))
  markup-system-spacing = #'((basic-distance . 19))
  left-margin = 1.5\cm
  line-width = 19.4\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-right = ##f
  ragged-last-bottom=##f
  system-count = #4
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Hristos a înviat"
  subtitle = "(2 variante)"
  composer = "Al. Podoleanu (1846 - 1907)"
  arranger = "G. Musicescu (1847 - 1903)"
  %meter = "Moderato"
  tagline=""
}

global = {
  \key f \major
  \autoBeamOff
  %\cadenzaOn
  \time 2/4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Hris -- tos a în -- vi -- at din morți! 
  Cu moar -- tea pe moar -- te căl -- când 
  și ce -- lor din mor -- min -- te via -- ță dă -- ru -- in -- du -- le.
  
  Hris -- tos a în -- vi -- at din morți 
  cu moar -- tea pe moar -- te căl -- când 
  și ce -- lor din mor -- min -- te via -- ță dă -- ru -- in -- du -- le.
}

menWords = \womenWords


sopMusic = \relative c'' {
  \partial 8 c8
  c4. b8 a4 b c4. b8 a4. \breathe 
  a8 a4 g8. a16 b4 a8. a16 g4.
  c8 c4. a8 b4 c d2 c4.
  c8( c4.) h8 c4 d c b a4. b8\rest \fermata \bar":|." \break
  \key g \major
  \time 3/4
  %\transpose a g {
   %\relative c'' {	  
    \partial 4 a4
    h2 a4 g( h) d d8([ c] h4) a g2
    h4 d d c h c d e2
    d4 c c d8 c h4 h c8([ h] a4) a
    h8 c d([ c] h4) a g2
    \fermata 
    \bar "|."
  %  }
  %}
}

altMusic = \relative c'' {
  a8 a4. g8 f4 g a4. g8 f4. f8 f4 e8. f16
  g4 f8. f16 e4. a8 a4. f8 g4 a f2
  a4. a8( a4.) gis8 a4 b a g f4. b8\rest
  %\transpose a g {
  % \relative c' {
    fis4 d2 fis4 g2 g4 h8([ a] g4) fis g2 d4 g4 g g g g g
    g2 gis4 a a h8 a g4 g a8([ g] fis4) fis g8 g h([ a] g4) fis d2
   %}
  %} 
}

tenorMusic = \relative c' {
  c8 c4. c8 c4 c c4. c8 c4. c8 c4 c8. c16
  c4 c8. c16 c4. c8 c4. c8 c4 c b2
  c4. c8( c4.) d8 c4 f c e c4. d,8\rest
  %\transpose a g {
  % \relative c' {
    d'4 g,2 a4 h2 h4 d2 c4 h2 g4 h h a g a h 
    c2 h4 a e' d8 d g,([ h]) d4 d d d d8 d e4( d) c h2
   %}
  %} 
}

bassMusic = \relative c {
  f8
  f4. f8 f4 f f4. c8 f4. 
  f8 f4 c8. f16 e4 f8. f16 c4.
  f8 f4. f8 f4 f b,8([ c d e]) f4.
  f8( f4.) f8 f4 b, c c f4. d8\rest
  \key g \major
  \time 3/4
  %\transpose a g {
   %\relative c {
    \partial 4 a'4
    g2 d4 h( g) d' d2 d4 g,2
    g4 g g g g' g g c,2
    e4 a a, d8 d g8([ h]) g,4
    g8([ h] d4) d g8 g c,4( d) d g2
    %}
  %}
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff = "staff" <<
     \new Voice { \voiceOne \global \sopMusic }
     %\new Lyrics \with { alignAboveContext = "staff" } { \sopWords }
     \new Voice { \voiceTwo \global \altMusic }
     \addlyrics { \womenWords }
     >>
    
    \new Staff <<
      \clef bass
      %\new Voice { \global \bassMusic }
      %\new Voice { \global \tenorMusic }
      %\new Lyrics \with { alignAboveContext = "staff" } { \tenorWords }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
      >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 55
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}